;This is a program template that is used in the text PIC Programming for Beginners.
;This template can be used as a starting point for PIC programs that you develop for
;the PIC16F676 device.  To use this template, make a copy of the file using the a unique
;file name and in a directory for the program that is created when you used the MPLab
;New Project Wizzard.  Then add this .asm file to the project using Add Files to Project...
;tab under the Project pull down menu option.
;Replace these comments with program specific comments.



	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define led5		0x05	;define led5 as pin 5 of PORTA
#define	led0		0x00	;define led0 as pin 0 of PORTA

;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	count					;used in delay routines
	tempa					;used in delay routines

;put your variable declarations here

	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	;call interrupt_service
	return					; interrupt trap - returns without re-enabling

;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	call    0x3FF      ; retrieve factory calibration value
	movwf	OSCCAL

	movlw	b'00000000'	
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00000000'	;All outputs 
	movwf	TRISA		;program PORTA
	movwf	TRISC		;Program PORTC
	movlw	b'00000000'	;no weak pull-ups on PORTA
	movwf	WPUA
	movlw	b'00000000'	;all digital
	movwf	ANSEL

	BANKSEL	Bank0		;back to bank0
	movlw	b'00000111'	;comparitor disconnected, low power state
	movwf	CMCON
	movlw	b'00000000'	;diable all interrupts
	movwf	INTCON
	clrf	PORTA
	clrf	PORTC
	bsf		PORTA,5		;start with pin 5 high, pin 0 low

;*****************************************************************************

;*****************************************************************************
;main program
main

	movlw	b'00100001'	;this is a mask used by the xorwf command to toggle
						;pins 5 and 0
	xorwf	PORTA,f		;XOR's the mask in the w reg with PORTA and sets pins
						;5 and 0 accordingly (toggels them-if on then off, if
						;off then on
	call	delay200ms	;this is a call to a delay subroutinet that will delay
						;200mS
	goto	main		;go back and do it again
	

;*****************************************************************************

interrupt_service			;an interrupt automatically clears GIE to
							;disable interrupts

;put your interrupt service routine here

;*****************************************************************************
	retfie					;sets GIE enabling global interrupts
;*****************************************************************************	


;******************************************************************************
;Delay Routines
;******************************************************************************
delay1ms
	movlw	.197
	movwf	count
	nop
	goto	$+1
	goto	$+1
dly1ms
	goto	$+1
	decfsz	count,F
	goto	dly1ms
	retlw	0

delay200ms
	movlw	.200
	movwf	tempa
dly200ms
	call	delay1ms
	decfsz	tempa,F
	goto	dly200ms
	movlw	.64
	movwf	count
tweek200ms
	decfsz	count,F
	goto	tweek200ms
	retlw	0
	end
